﻿
$(function() {
	
	creatGrid();

	//derive条件表单
	$('#excelForm').form({
		url : baseUrl +"/admin/C050/outChengJiExcel.html",
		success : function(data) {
			$.messager.alert('Hint',data,'info');
		}
	});
	
	// 职位分类
	$('#positionCombox').combobox({
		url : baseUrl +'/admin/U060/findPosition.html',
		panelHeight : 300,
		valueField : 'positionid',
		textField : 'name'
	});
	
	//see窗口
	$('#seewin').window({    
		width : 800,
		height : 500,
		draggable : false,
		resizable : false,
		collapsible : false,
		minimizable : true,
		maximizable : true,
		closable : true,
		closed : true,
		inline : true,
		maximized:true,
		title : 'review the exam paper',
		modal : true   
	});
	
});

function creatGrid() {
	$('#itemlist').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : false,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : true,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据排序。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50, 100 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : baseUrl +"/admin/C050/listAllChengji.html",
		frozenColumns : [ [ {
			field : 'select',
			title : 'select',
			width : 50,
			checkbox : true
		} ] ],
		columns : [ [ {
			field : 'kcname',
			title : 'course name',
			width : 200,
			sortable : true,
			halign: 'center',
			align : 'left'
		}, {
			field : 'totalsorce',
			title : 'total score',
			width : 50,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'sorce',
			title : 'score',
			width : 50,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'kstimes',
			title : 'exam times',
			width : 80,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'examTimeLength',
			title : 'exam time length',
			width : 260,
			sortable : true,
			halign: 'center',
			align : 'center'
		},{
			field : 'username',
			title : 'user name',
			width : 100,
			sortable : true,
			align : 'left'
		}, {
			field : 'realname',
			title : 'real name',
			width : 100,
			sortable : true,
			align : 'left'
		}, {
			field : 'groupname',
			title : 'group name',
			width : 100,
			sortable : true,
			align : 'left'
		}, {
			field : 'okrateType',
			title : 'pass or fail',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'manage',
			title : 'manage',
			align : 'center',
			width : 150,
			formatter : fmup
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.see_chengji').linkbutton({
				iconCls : 'icon-search',
				plain : true
			});
			$('.out_chengji').linkbutton({
				iconCls : 'icon-word',
				plain : true
			});
		}
	});

}
function fmup(value, rowData, rowIndex) {
	
	var id = rowData.kcoid;
	var timelong = rowData.timelong;
	var str;

	if(timelong != "unsubmit exam paper"){
		str="<a onclick='openSeeWin("+ id+")' class='see_chengji'>see</a>";
		str += "<a onclick='outWord("+ id+");' class='out_chengji' >derive</a>";
	}else{
		str="<a onclick='openSeeWin("+ id+")' disabled='true' class='see_chengji'>see</a>";
		str += "<a onclick='outWord("+ id+");'  disabled='true' class='out_chengji' >derive</a>";
	}
	
	return str;
	
}
//======================================查看试卷=================================//
//打开查看窗口
function openSeeWin(id) {
	
	window.parent.closeTabByTitle("Preview of grade paper");
	
	window.parent.openTab("Preview of grade paper", baseUrl+"/admin/C050/manageChengJiPreview.html?id="+id);
	
}

//导出
function outWord(id){
	
	window.location.href=baseUrl +"/admin/C050/exportWord.html?id="+id;
	
}

//查询
function seachChengjiByParam() {
	//给隐藏表单赋值
	var kcname=$("#kcname").val();
	
	var kcusername=$("#kcusername").val();
	
	var search_examcard = $("#examcardlike").val();
	
	var search_positionid = $('#positionCombox').combobox('getValue');
	
	$("#exkcname").attr("value",kcname);
	
	$("#exkcusername").attr("value",kcusername);
	
	$("#exExamcard").val(search_examcard);
	
	$("#expositionid").val(search_positionid);
	
	var param = {
			
		kcname : kcname,
		
		kcusername:kcusername,
		
		examcard:search_examcard,
		
		positionid:search_positionid
		
	};
	
	$('#itemlist').datagrid('load', param);
	
}
//刷新
function reloadGrid() {
	$('#itemlist').datagrid('clearSelections');
	$('#itemlist').datagrid('reload');
}

//导出Excel
function exportExcel() {
	
	$('#excelForm').submit();
	
	return false;
	
}
